package com.tchudyk.text_canvas;

import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class FxNodeMeasurer implements NodeMeasurer {
    private final Group root = new Group();
    private final Scene scene = new Scene(root);
    private final Text text = new Text();

    public FxNodeMeasurer() {
        scene.setRoot(root);
    }

    @Override
    public double[] measure(Node n) {
        boolean onScene = n.getScene() != null;

        if (!onScene) {
            root.getChildren().add(n);
        }

        n.applyCss();
        n.autosize();

        double pw = n.prefWidth(-1);
        if (pw <= 0) {
            pw = n.getLayoutBounds().getWidth();
        }
        double ph = n.prefHeight(-1);
        if (ph <= 0) {
            ph = n.getLayoutBounds().getHeight();
        }

        if (!onScene) {
            root.getChildren().remove(n);
        }
        return new double[]{pw, ph};
    }

    @Override
    public TextMetrics measureText(String text, Font font) {
        this.text.setText(text);
        this.text.setFont(font);
        Bounds layoutBounds = this.text.getLayoutBounds();
        double ascent = this.text.getBaselineOffset(); // part above baseline
        return new TextMetrics(
                layoutBounds.getWidth(),
                ascent,
                layoutBounds.getHeight() - ascent
        );
    }
}
