package com.tchudyk.text_canvas;

import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class FxNodes {

    private final ObservableList<Node> canvasNodes;
    private final InvalidationListener sizeChangeListener;

    public FxNodes(ObservableList<Node> canvasNodes, Runnable changeListener) {
        this.canvasNodes = canvasNodes;
        this.sizeChangeListener = _ -> changeListener.run();
    }

    public void registerOnScreen(Region node) {
        if (!canvasNodes.contains(node)) {
            canvasNodes.add(node);
            node.widthProperty().addListener(sizeChangeListener);
            node.heightProperty().addListener(sizeChangeListener);
        }
    }

    public void unregisterFromScreen(Region node) {
        canvasNodes.remove(node);
        node.widthProperty().removeListener(sizeChangeListener);
        node.heightProperty().removeListener(sizeChangeListener);
    }
}
