package com.tchudyk.text_canvas;

import com.tchudyk.text_canvas.segment.SegmentStyle;
import com.tchudyk.text_canvas.segment.blocks.BlockSegment;
import com.tchudyk.text_canvas.segment.blocks.InlineBlockSegment;
import com.tchudyk.text_canvas.segment.node.NodeSegment;
import com.tchudyk.text_canvas.segment.text.TextSegment;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class Main extends Application {

    @Override
    public void start(Stage stage) {
        TextCanvas textCanvas = new TextCanvas();
        SplitPane splitPane = new SplitPane(textCanvas, new Pane());

        Scene scene = new Scene(splitPane);
        stage.setScene(scene);

        SegmentStyle defaultStyle = new SegmentStyle(Font.font("System", 20), Color.BLACK);
        SegmentStyle defaultBoldStyle = new SegmentStyle(Font.font("System", FontWeight.BOLD,20), Color.BLACK);
        SegmentStyle defaultRedStyle = new SegmentStyle(Font.font("System", 20), Color.RED);
        SegmentStyle largeStyle = new SegmentStyle(Font.font("System", FontWeight.BOLD, 70), Color.BLACK);

        for (int i = 0; i < 2; i++) {
            textCanvas.addSegment(new TextSegment("Lorem ", defaultBoldStyle));

            Button b = new Button("ipsum" + i);
            b.setOnAction(e -> {
                if (b.getText().equals("ipsum")) {
                    b.setText("ipsum dolor sit amet");
                } else {
                    b.setText("ipsum");
                }
            });
            textCanvas.addSegment(new NodeSegment(b, defaultStyle));

            textCanvas.addSegment(new TextSegment(", consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad ", defaultStyle));
            textCanvas.addSegment(new TextSegment("miniym.", largeStyle));
            textCanvas.addSegment(new TextSegment(" veniam,\nquis nostrud exercitation ", defaultStyle));
            textCanvas.addSegment(new TextSegment("ullamco laboris nisi ", defaultRedStyle));
            textCanvas.addSegment(new TextSegment("ut aliquip ex ea commodo consequat. ", defaultStyle));

            InlineBlockSegment segment1 = new InlineBlockSegment(defaultStyle);
            segment1.addSegment(new TextSegment("Duis aute irure dolor", defaultBoldStyle));
            segment1.addSegment(new BlockSegment(defaultStyle, new TextSegment("Block 1", defaultStyle)));
            segment1.addSegment(new BlockSegment(defaultStyle, new TextSegment("Block 2", defaultStyle)));
            segment1.addSegment(new BlockSegment(defaultStyle, new TextSegment("Block 3", defaultStyle)));
            textCanvas.addSegment(segment1);

            textCanvas.addSegment(new TextSegment(" In reprehenderit in voluptate velit esse cillum dolore", defaultStyle));

            textCanvas.addSegment(new BlockSegment(defaultStyle, new TextSegment("Eu fugiat nulla pariatur", defaultStyle)));

            ImageView imageView = new ImageView("https://images.unsplash.com/photo-1759434192768-fe3facebd5f6?q=80&w=1171&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D");
            imageView.setFitWidth(200);
            imageView.setPreserveRatio(true);
            textCanvas.addSegment(new NodeSegment(new Pane(imageView), defaultStyle));
            textCanvas.addSegment(new TextSegment(" Duis aute irure dolor reprehenderit in voluptate velit esse", defaultStyle));
        }

        stage.setWidth(820);
        stage.setHeight(420);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }

}
