package com.tchudyk.text_canvas.layout;

import java.util.ArrayList;
import java.util.List;

public class LayoutLine {
    public double y;
    public double ascent;
    public double descent;
    public final List<SegmentReference> segments = new ArrayList<>();

    public LayoutLine(double y, double ascent, double descent) {
        this.y = y;
        this.ascent = ascent;
        this.descent = descent;
    }

    public void commitHeight(double ascentHeight, double descentHeight) {
        this.ascent = ascentHeight;
        this.descent = descentHeight;
        this.segments.forEach(s -> s.updatedLineHeight(ascentHeight));
    }
}
