package com.tchudyk.text_canvas.layout;

import com.tchudyk.text_canvas.segment.Segment;

import java.util.List;

public class SegmentReference {
    private final Segment segment;
    private final short offset;
    private short limit;
    private double x;
    private double width;
    private double ascentHeight;

    private List<LayoutLine> innerLines;

    public SegmentReference(Segment segment, short offset, short limit, double x, double width, double ascentHeight) {
        this.segment = segment;
        this.offset = offset;
        this.limit = limit;
        this.x = x;
        this.width = width;
        this.ascentHeight = ascentHeight;
    }

    public void updateX(double x) {
        this.x = x;
    }

    public void updateInnerLines(List<LayoutLine> innerLines) {
        this.innerLines = innerLines;
    }

    public void updateLimit(int limit, double width) {
        this.limit = (short) limit;
        this.width = width;
    }

    public Segment segment() {
        return segment;
    }

    public short limit() {
        return limit;
    }

    public short offset() {
        return offset;
    }

    public double x() {
        return x;
    }

    public double width() {
        return width;
    }

    public double ascentHeight() {
        return ascentHeight;
    }

    public List<LayoutLine> innerLines() {
        return innerLines;
    }

    public void updatedLineHeight(double ascentHeight) {
        double paddingTop = ascentHeight - this.ascentHeight;
        if (paddingTop != 0 && innerLines != null && !innerLines.isEmpty()) {
            innerLines.forEach(l -> l.commitHeight(l.ascent + paddingTop, l.descent));
        }
    }
}
