package com.tchudyk.text_canvas.segment.blocks;

import com.tchudyk.text_canvas.segment.Segment;
import com.tchudyk.text_canvas.segment.SegmentStyle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseBlockSegment implements Segment {

    protected SegmentStyle style;
    final List<Segment> childSegments = new ArrayList<>();

    public BaseBlockSegment(SegmentStyle style) {
        this.style = style;
    }

    public void addSegment(Segment segment) {
        childSegments.add(segment);
    }

    public List<Segment> childSegments() {
        return Collections.unmodifiableList(childSegments);
    }

    @Override
    public SegmentStyle style() {
        return style;
    }
}
